// 特定の警告画面での自動リダイレクト
function checkAndRedirect() {
    const targetText = "Click on the link below to view the video";
    const videoDomain = "https://video.twimg.com/";

    // ページ内に特定の文言が含まれているか確認
    if (document.body && document.body.textContent.includes(targetText)) {
        // video.twimg.com へのリンクを探す
        const links = document.getElementsByTagName('a');
        for (const link of links) {
            if (link.href && link.href.startsWith(videoDomain)) {
                console.log('Detected video link redirect page. Simulating click:', link.href);
                // リファラ操作などを加えず、純粋にユーザーがクリックした挙動を再現する
                link.click();
                return;
            }
        }
    }
}

// 実行
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', checkAndRedirect);
} else {
    checkAndRedirect();
}
