// VVV Extension Popup

const API_BASE = 'https://vvv.jkjk.uk';

document.getElementById('save-fav').addEventListener('click', () => saveToVVV('favorites'));
document.getElementById('save-todo').addEventListener('click', () => saveToVVV('todo'));

async function saveToVVV(saveType) {
  const statusEl = document.getElementById('status');
  statusEl.className = 'status show';
  statusEl.textContent = '保存中...';

  try {
    // 現在のタブを取得
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
    const url = tab.url;
    const title = tab.title || url;

    // トークンを取得
    const { accessToken } = await chrome.storage.local.get('accessToken');

    if (!accessToken) {
      // ログインページを開く
      chrome.tabs.create({ url: `${API_BASE}/login?extension=1` });
      window.close();
      return;
    }

    // エンドポイントを選択
    const endpoint = saveType === 'todo'
      ? `${API_BASE}/api/extension/save-todo`
      : `${API_BASE}/api/extension/save`;

    // APIリクエスト
    const response = await fetch(endpoint, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': `Bearer ${accessToken}`
      },
      body: JSON.stringify({
        href: url,
        title: title,
        src: url
      })
    });

    if (response.status === 401) {
      // トークン期限切れ
      chrome.storage.local.remove('accessToken');
      chrome.tabs.create({ url: `${API_BASE}/login?extension=1` });
      window.close();
      return;
    }

    if (response.ok) {
      const data = await response.json();
      const typeLabel = saveType === 'todo' ? 'TODO' : 'お気に入り';
      statusEl.className = 'status show success';
      statusEl.textContent = `${typeLabel}に保存しました`;

      // バッジ表示
      const badgeText = saveType === 'todo' ? '☑' : '★';
      const badgeColor = saveType === 'todo' ? '#17a2b8' : '#4CAF50';
      chrome.action.setBadgeText({ text: badgeText, tabId: tab.id });
      chrome.action.setBadgeBackgroundColor({ color: badgeColor });

      // 1秒後にポップアップを閉じる
      setTimeout(() => {
        chrome.action.setBadgeText({ text: '', tabId: tab.id });
        window.close();
      }, 1000);
    } else {
      const error = await response.json();
      statusEl.className = 'status show error';
      statusEl.textContent = error.detail || 'エラーが発生しました';
    }
  } catch (err) {
    console.error('VVV Extension Error:', err);
    statusEl.className = 'status show error';
    statusEl.textContent = 'ネットワークエラー';
  }
}
